/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.init;

import com.finallion.graveyard.config.GraveyardConfig;
import com.finallion.graveyard.structures.HauntedHouse;
import com.finallion.graveyard.structures.LargeBirchTree;
import com.finallion.graveyard.structures.LargeWalledGraveyard;
import com.finallion.graveyard.structures.MediumWalledGraveyard;
import com.finallion.graveyard.structures.MushroomGrave;
import com.finallion.graveyard.structures.SmallDesertGrave;
import com.finallion.graveyard.structures.SmallGrave;
import com.finallion.graveyard.structures.SmallMountainGrave;
import com.finallion.graveyard.structures.SmallSavannaGrave;
import com.finallion.graveyard.structures.SmallWalledGraveyard;
import com.finallion.graveyard.structures.SmallWalledGraveyardDesert;
import com.finallion.graveyard.structures.SmallWalledGraveyardSavanna;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class TGStructures {
    public static final List<Structure> MOD_STRUCTURES = new ArrayList<Structure>();
    public static final DeferredRegister<Structure<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"graveyard");
    public static RegistryObject<Structure<NoFeatureConfig>> SMALL_WALLED_GRAVEYARD = DEFERRED_REGISTRY_STRUCTURE.register("small_walled_graveyard", () -> new SmallWalledGraveyard((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static RegistryObject<Structure<NoFeatureConfig>> SMALL_WALLED_GRAVEYARD_SAVANNA = DEFERRED_REGISTRY_STRUCTURE.register("small_walled_graveyard_savanna", () -> new SmallWalledGraveyardSavanna((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static RegistryObject<Structure<NoFeatureConfig>> SMALL_WALLED_GRAVEYARD_DESERT = DEFERRED_REGISTRY_STRUCTURE.register("small_walled_graveyard_desert", () -> new SmallWalledGraveyardDesert((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static RegistryObject<Structure<NoFeatureConfig>> SMALL_GRAVE = DEFERRED_REGISTRY_STRUCTURE.register("small_grave", () -> new SmallGrave((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static RegistryObject<Structure<NoFeatureConfig>> SMALL_DESERT_GRAVE = DEFERRED_REGISTRY_STRUCTURE.register("small_desert_grave", () -> new SmallDesertGrave((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static RegistryObject<Structure<NoFeatureConfig>> SMALL_SAVANNA_GRAVE = DEFERRED_REGISTRY_STRUCTURE.register("small_savanna_grave", () -> new SmallSavannaGrave((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static RegistryObject<Structure<NoFeatureConfig>> SMALL_MOUNTAIN_GRAVE = DEFERRED_REGISTRY_STRUCTURE.register("small_mountain_grave", () -> new SmallMountainGrave((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static RegistryObject<Structure<NoFeatureConfig>> MUSHROOM_GRAVE = DEFERRED_REGISTRY_STRUCTURE.register("mushroom_grave", () -> new MushroomGrave((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static RegistryObject<Structure<NoFeatureConfig>> LARGE_BIRCH_TREE = DEFERRED_REGISTRY_STRUCTURE.register("large_birch_tree", () -> new LargeBirchTree((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static RegistryObject<Structure<NoFeatureConfig>> MEDIUM_WALLED_GRAVEYARD = DEFERRED_REGISTRY_STRUCTURE.register("medium_walled_graveyard", () -> new MediumWalledGraveyard((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static RegistryObject<Structure<NoFeatureConfig>> LARGE_WALLED_GRAVEYARD = DEFERRED_REGISTRY_STRUCTURE.register("large_walled_graveyard", () -> new LargeWalledGraveyard((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static RegistryObject<Structure<NoFeatureConfig>> HAUNTED_HOUSE = DEFERRED_REGISTRY_STRUCTURE.register("haunted_house", () -> new HauntedHouse((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void register() {
        TGStructures.setupMapSpacingAndLand((Structure)SMALL_WALLED_GRAVEYARD.get(), GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_SEPARATION, GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_SPACING, GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_SALT, true);
        TGStructures.setupMapSpacingAndLand((Structure)SMALL_WALLED_GRAVEYARD_SAVANNA.get(), GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_SAVANNA_SEPARATION, GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_SAVANNA_SPACING, GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_SAVANNA_SALT, true);
        TGStructures.setupMapSpacingAndLand((Structure)SMALL_WALLED_GRAVEYARD_DESERT.get(), GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_DESERT_SEPARATION, GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_DESERT_SPACING, GraveyardConfig.INSTANCE.SMALL_GRAVEYARD_DESERT_SALT, true);
        TGStructures.setupMapSpacingAndLand((Structure)SMALL_GRAVE.get(), GraveyardConfig.INSTANCE.GRAVE_SEPARATION, GraveyardConfig.INSTANCE.GRAVE_SPACING, GraveyardConfig.INSTANCE.GRAVE_SALT, true);
        TGStructures.setupMapSpacingAndLand((Structure)SMALL_DESERT_GRAVE.get(), GraveyardConfig.INSTANCE.DESERT_GRAVE_SEPARATION, GraveyardConfig.INSTANCE.DESERT_GRAVE_SPACING, GraveyardConfig.INSTANCE.DESERT_GRAVE_SALT, true);
        TGStructures.setupMapSpacingAndLand((Structure)SMALL_SAVANNA_GRAVE.get(), GraveyardConfig.INSTANCE.SAVANNA_GRAVE_SEPARATION, GraveyardConfig.INSTANCE.SAVANNA_GRAVE_SPACING, GraveyardConfig.INSTANCE.SAVANNA_GRAVE_SALT, true);
        TGStructures.setupMapSpacingAndLand((Structure)SMALL_MOUNTAIN_GRAVE.get(), GraveyardConfig.INSTANCE.MOUNTAIN_GRAVE_SEPARATION, GraveyardConfig.INSTANCE.MOUNTAIN_GRAVE_SPACING, GraveyardConfig.INSTANCE.MOUNTAIN_GRAVE_SALT, true);
        TGStructures.setupMapSpacingAndLand((Structure)MUSHROOM_GRAVE.get(), GraveyardConfig.INSTANCE.MUSHROOM_GRAVE_SEPARATION, GraveyardConfig.INSTANCE.MUSHROOM_GRAVE_SPACING, GraveyardConfig.INSTANCE.MUSHROOM_GRAVE_SALT, true);
        TGStructures.setupMapSpacingAndLand((Structure)LARGE_BIRCH_TREE.get(), GraveyardConfig.INSTANCE.BIRCH_TREE_SEPARATION, GraveyardConfig.INSTANCE.BIRCH_TREE_SPACING, GraveyardConfig.INSTANCE.BIRCH_TREE_SALT, true);
        TGStructures.setupMapSpacingAndLand((Structure)MEDIUM_WALLED_GRAVEYARD.get(), GraveyardConfig.INSTANCE.MEDIUM_GRAVEYARD_SEPARATION, GraveyardConfig.INSTANCE.MEDIUM_GRAVEYARD_SPACING, GraveyardConfig.INSTANCE.MEDIUM_GRAVEYARD_SALT, true);
        TGStructures.setupMapSpacingAndLand((Structure)LARGE_WALLED_GRAVEYARD.get(), GraveyardConfig.INSTANCE.LARGE_GRAVEYARD_SEPARATION, GraveyardConfig.INSTANCE.LARGE_GRAVEYARD_SPACING, GraveyardConfig.INSTANCE.LARGE_GRAVEYARD_SALT, true);
        TGStructures.setupMapSpacingAndLand((Structure)HAUNTED_HOUSE.get(), GraveyardConfig.INSTANCE.HAUNTED_HOUSE_SEPARATION, GraveyardConfig.INSTANCE.HAUNTED_HOUSE_SPACING, GraveyardConfig.INSTANCE.HAUNTED_HOUSE_SALT, true);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, int separation, int spacing, int salt, boolean transformSurroundingLand) {
        MOD_STRUCTURES.add(structure);
        TGStructures.setupMapSpacingAndLand(structure, new StructureSeparationSettings(spacing, separation, salt), transformSurroundingLand);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }
}

